Scriptname _SLSubmitRepeatEffect extends ActiveMagicEffect  

import game

_SLSubmitConfig Property _SLConfig auto
_SLSubmitFunctions Property _SLFunctions auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitScene Property _SLScene auto

GlobalVariable Property RepeatGlobal  Auto  
GlobalVariable Property SuccessChance  Auto  
GlobalVariable Property SuccessRoll  Auto  
GlobalVariable Property BoundGlobal  Auto
GlobalVariable Property _SLSubmitSurrenderGlobal  Auto
SPELL Property _SLSubmitAssign  Auto  
SPELL Property _SLSubmitSurrender Auto  
Actor Property PlayerRef Auto

Event OnEffectFinish(actor Target, actor Caster)

; // Code for the success algorithm	
	If (BoundGlobal.GetValue() != 0)
		SuccessChance.SetValue(RepeatGlobal.GetValue())
		SuccessRoll.SetValue(Utility.RandomInt(0, 100))
		_SLScene.WRT(0.1)
		If(_SLConfig.debugActive)
			Debug.Notification(SuccessChance.GetValue() + "% chance to be noticed. You rolled a " + SuccessRoll.GetValue() + "%.")
		EndIf
; // Code for what happens on success
		If (SuccessChance.GetValue() <= SuccessRoll.GetValue())
			If (_SLConfig.RepeatActive)
				_SLFunctions.RepeatRate()
			EndIf
			RepeatGlobal.SetValue(RepeatGlobal.GetValue() + 10)
		Else
; // Code for what happens on failure
			_SLScene.WRT(0.1)
			If(_SLConfig.debugActive)
				Debug.Notification("Your vulnerable position may have attracted some attention...")
			EndIf
			_SLSubmitSurrenderGlobal.SetValue(1)
			_SLSubmitAssign.Cast(PlayerRef)
			_SLSubmitSurrender.Cast(PlayerRef)
			If (_SLConfig.RepeatActive)
				_SLFunctions.RepeatRate()
			EndIf
			If (RepeatGlobal.GetValue() < 100)
				RepeatGlobal.SetValue(RepeatGlobal.GetValue() + 10)
			EndIf
		EndIf
	EndIf
EndEvent